const Admin = require('../models/Admin');



exports.CreateOne = async (req, res) => {
    try {
        const { username, email, password } = req.body;
        if (!username || !email || !password) {
            return res.status(400).json({ message: 'All Data must be provided' });
        }
        const oldAdmin = await Admin.findOne({ email });
        if (oldAdmin) {
            return res.status(409).json({ message: 'Such Admin is already registered' });
        }
        const admin = await Admin.create({ username, email, password });
        return res.status(201).json({ message: 'Successfully created a new admin', admin });
    } catch (error) {
        return res.status(500).json({ error: error.message, message: 'Error creating new admin' });
    }
}


exports.DeleteOne = async (req, res) => {
    try {
        const id = req.params.id;
        if (!id) {
            return res.status(400).json({ message: 'Id must be provided' });
        }
        const admin = await Admin.findById(id);
        if (admin.isPrimary) {
            return res.status(407).json({ message: 'Can not delete primary admin' });
        }
        await Admin.findByIdAndDelete(id);
        return res.status(201).json({ message: 'Successfully deleted admin' });
    } catch (error) {
        return res.status(500).json({ error: error.message, message: 'Error deleting admin' });
    }
}


exports.Login = async (req, res) => {
    try {
        const { email, password } = req.body;
        console.log("abc===>>>", req.body)
        if (!email || !password) {
            return res.status(400).json({ message: 'All Data must be provided' });
        }
        const admin = await Admin.findOne({ email });
        if (!admin || admin.password !== password) {
            return res.status(400).json({ message: 'Invalid Credentials' });
        }
        return res.status(200).json({ message: 'Successfully Logged in', data:admin });
    } catch (error) {
        // console.log("is match 1st error===>>>", error)
        return res.status(500).json({ error: error.message, message: 'Error logging in' });
    }
}

exports.GetAll = async (req, res) => {
    try {
        const admins = await Admin.find({ isPrimary: false });
        return res.status(200).json({ message: 'Successfully got all admins', admins });
    } catch (error) {
        return res.status(500).json({ message: 'Error getting all admins' });
    }
}


exports.MakePrimary = async (req, res) => {
    try {
        const id = req.params.id;
        const admin = await Admin.findByIdAndUpdate(id, { isPrimary: true });
        return res.status(200).json({ message: 'Successfully made this admin a primary admin', admin });
    } catch (error) {
        return res.status(500).json({ message: 'Error changing status of admin' });
    }
}
exports.changePassword = async (req, res) => {
    try {

        const id = req.params.id;
        const { oldPassword, newPassword } = req.body
        const isAdmin = await Admin.findById(id);
        
         // check of is id provided

        if(!id){
            res.status(404).json({
                message:"Id must be provided"
            })
        }

        //checking is admin exists
        if (!isAdmin) {
            return res.status(404).json({
                message: "User not found",
            })
        }

        //checking for empty fields

        if (!oldPassword || !newPassword) {
            return res.status(400).json({
                message: "Empty fields"
            })
        }

        // checking if user password is equal to old password

        if (isAdmin.password != oldPassword){
            res.status(401).json({
                message:"Invalid Credentials"
            })
        }

        isAdmin.password=newPassword
        const passwordChanged=await isAdmin.save();

        if(!passwordChanged){
            return res.status(500).json({
                message:"Error while changing Password"
            })
        }
        return res.status(200).json({
            message:"Password changed "
        })

    } catch (error) {
        return res.status(500).json({
            message: "Error in changing password",
            error:error
        })
    }
}




