const { success } = require("concurrently/src/defaults");
const LTO = require("../models/LTO");



exports.getAllLTOs =async function (req,res){
    try{
        const ltos = await LTO.find();
        res.status(200).json(ltos);
    }catch(error){
        res.status(500).json({success:false,message:error.message});
    }
}


exports.getLTOById =async function (req,res){
    try {
        const lto = await LTO.findById(req.params.id);
        if (!lto) {
            return res.status(404).json({ message: 'LTO not found' });
        }
        res.status(200).json(lto);
    } catch (error) {
        res.status(500).json({success:false,message:error.message});
    }
}


exports.createLTO =async function (req,res){
    const { title, link, image, oldPrice, newPrice, endDate } = req.body;
    const lto = new LTO({ title, link, image, oldPrice, newPrice, endDate });

    try {
        const savedLto = await lto.save();
        res.status(201).json(savedLto);
    } catch (error) {
        res.status(400).json({ message: error.message });
    }
}

exports.updateLTO =async function (req,res){
    try {
        const updatedLto = await LTO.findByIdAndUpdate(req.params.id, req.body, { new: true });
        if (!updatedLto) {
            return res.status(404).json({ message: 'LTO not found' });
        }
        res.status(200).json(updatedLto);
    } catch (error) {
        res.status(400).json({ message: error.message });
    }
}

exports.deleteLTO =async function (req,res){
    try {
        const deletedLto = await LTO.findByIdAndDelete(req.params.id);
        if (!deletedLto) {
            return res.status(404).json({ message: 'LTO not found' });
        }
        res.status(200).json({ message: 'LTO deleted successfully' });
    } catch (error) {
        res.status(500).json({ message: error.message });
    }
}

