const mongoose = require("mongoose");

const paymentSchema = new mongoose.Schema({
  paymentMethodId: {
    type: String,
    // required: true, // NOTE: Paypal doesn't have this field
  },
  amount: {
    type: Number,
    required: true,
  },
  shipping: {
    type: Number,
    required: true,
  },
  products: {
    type: Array,
    required: true,
  },
  customerDetails: {
    type: Object,
    required: true,
  },
  cardDetails: {
    type: Object,
    // required: true, // NOTE: Paypal doesn't have this field
  },
  paymentStatus: {
    type: String,
    required: true,
  },
  createdAt: {
    type: Date,
    default: Date.now,
  },
});

module.exports = mongoose.model("Payment", paymentSchema);
