require('dotenv').config();


exports.tradeApplicationRecievedUser = ({ username }) => {
    return `
        <div style="font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; background-color: #f9f9f9; padding: 20px;">
            <div style="max-width: 600px; margin: auto; background-color: #ffffff; padding: 20px; border-radius: 8px; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);">
                <h2 style="color: #4CAF50; text-align: center;">Trade Application Received</h2>
                <p style="color: #333; font-size: 16px;">Dear ${username},</p>
                <p style="color: #333; font-size: 16px;">Thank you for registering as a trader on our platform. We have received your application and our team will review it shortly.</p>
                <p style="color: #333; font-size: 16px;">You will receive a notification via email once your application has been reviewed and approved.</p>
                <p style="color: #333; font-size: 16px;">In the meantime, feel free to explore our website and learn more about the trading opportunities we offer.</p>
                <p style="color: #333; font-size: 16px;">Best regards,</p>
                <p style="color: #333; font-size: 16px;">${process.env.BUSINESS_NAME}</p>
            </div>
        </div>
    `;
};


exports.tradeApplicationRecievedAdmin = ({ username, email }) => {
    return `
        <div style="font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; background-color: #f9f9f9; padding: 20px;">
            <div style="max-width: 600px; margin: auto; background-color: #ffffff; padding: 20px; border-radius: 8px; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);">
                <h2 style="color: #FF5722; text-align: center;">New Trade Application Received</h2>
                <p style="color: #333; font-size: 16px;">Dear Admin,</p>
                <p style="color: #333; font-size: 16px;">A new trade application has been submitted by the following user:</p>
                <ul style="color: #333; font-size: 16px;">
                    <li><strong>Username:</strong> ${username}</li>
                    <li><strong>Email:</strong> ${email}</li>
                </ul>
                <p style="color: #333; font-size: 16px;">Please review the application and take appropriate action to approve or delete it.</p>
                <p style="color: #333; font-size: 16px;">Best regards,</p>
                <p style="color: #333; font-size: 16px;">${process.env.BUSINESS_NAME}</p>
            </div>
        </div>
    `;
};

exports.tradeApplicationApprovedUser = ({ username }) => {
    return `
        <div style="font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; background-color: #f9f9f9; padding: 20px;">
            <div style="max-width: 600px; margin: auto; background-color: #ffffff; padding: 20px; border-radius: 8px; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);">
                <h2 style="color: #4CAF50; text-align: center;">Trade Application Approved</h2>
                <p style="color: #333; font-size: 16px;">Dear ${username},</p>
                <p style="color: #333; font-size: 16px;">We are pleased to inform you that your application to register as a trader on our platform has been approved.</p>
                <p style="color: #333; font-size: 16px;">You can now log in to your account and start trading.</p>
                <p style="color: #333; font-size: 16px;">If you have any questions or need further assistance, please feel free to contact us.</p>
                <p style="color: #333; font-size: 16px;">Best regards,</p>
                <p style="color: #333; font-size: 16px;">${process.env.BUSINESS_NAME}</p>
            </div>
        </div>
    `;
};





















