const Address = require('../models/Address');


// POST /api/address/create

exports.Create = async function (req, res) {
    try {
        const { country, city, zipcode, streetAddress, phoneNumber, userId } = req.body;
        console.log(country, zipcode, streetAddress, phoneNumber, userId)
        if (!userId) {
            return res.status(400).json({ success: false, message: 'User Id must be provided' });
        }
        if (!country || !streetAddress || !zipcode || !city) {
            return res.status(400).json({ success: false, message: 'The complete address must be provided' });
        }
        const address = await Address.create(req.body);
        return res.status(200).json({ success: true, message: 'Successfully created a new address !' });
    } catch (error) {
        console.log('Error creating address: ', error);
        return res.status(500).json({ success: false, message: error.message });
    }
}


// PUT /api/address/update/id

exports.Update = async function (req, res) {
    try {
        const id = req.params.id;
        const existingAddress = await Address.findById(id);
        if (!existingAddress) {
            return res.status(404).json({ success: false, message: 'Such Address Does not exists' });
        }
        const address = await Address.findByIdAndUpdate(id, req.body, { new: true });
        return res.status(200).json({ success: true, message: 'Successfully updated a new address !', address });
    } catch (error) {
        console.log('Error updating address: ', error);
        return res.status(500).json({ success: false, message: error.message });
    }
}


// GET /api/address/getAll/userId

exports.getAll = async function (req, res) {
    try {
        const userId = req.params.userId;
        if (!userId) {
            return res.status(400).json({ success: false, message: 'Please provide a userid to get all corresponding addresses' });
        }
        const addresses = await Address.find({ userId });
        return res.status(200).json({ success: true, message: 'Successfully found relevant addresses', addresses });
    } catch (error) {
        console.log('Error getting address: ', error);
        return res.status(500).json({ success: false, message: error.message });
    }
}

exports.getById = async function (req, res) {
    try {

        const id = req.params.id
        if (!id) {
            return res.status(400).json({
                message: 'Id must be required'
            })
        }

        const response = await Address.findById(id);

        if (!response) {
            return res.status(404).json({
                message: 'Not found',
            })
        }

        return res.status(200).json({
            message: 'Address found',
            response,
        })

    } catch (error) {
        return res.status(500).json({
            message: "error in getting address",
            error: error.message
        })
    }
}
// DELETE /api/address/delete/id

exports.Delete = async function (req, res) {
    try {
        const id = req.params.id;
        if (!id) {
            return res.status(400).json({ success: false, message: 'Please provide an id to delete the address' });
        }
        await Address.findByIdAndDelete(id);
        return res.status(200).json({ success: true, message: 'Successfully deleted address' });
    } catch (error) {
        console.log('Error deleting address: ', error);
        return res.status(500).json({ success: false, message: error.message });
    }
}










