const socketIO = require('socket.io');

let io;

function setupTraderNotification(server) {
    io = socketIO(server, {
        cors: {
            origin: "*",
            methods: ["GET", "POST"]
        }
    });

    io.on('connection', (socket) => {
        console.log('Admin connected:', socket.id);

        // Example event for joining a room
        socket.on('joinRoom', (room) => {
            socket.join(room);
            console.log(`Trader ${socket.id} joined room ${room}`);
        });

        // Example event for sending notifications
        socket.on('sendNotification', (data) => {
            const { room, message } = data;
            io.to(room).emit('receiveNotification', message);
            console.log(`Notification sent to room ${room}: ${message}`);
        });

        socket.on('disconnect', () => {
            console.log('Admin disconnected:', socket.id);
        });
    });

    return io;
}

function getIO() {
    if (!io) {
        throw new Error('Socket.io not initialized!');
    }
    return io;
}

module.exports = {
    setupTraderNotification,
    getIO
};

