const { Router } = require("express");
const Payment = require("../controllers/payment");
const router = Router();

router.post("/make-payment", Payment.MakePayment);
router.post("/make-saved-payment", Payment.MakeSavedPayment);
router.post("/savePaymentMethod", Payment.savePaymentMethod);
router.post(
  "/registerStripeCustomer/:traderId",
  Payment.registerStripeCustomer
);
router.get("/getSavedPaymentMethods/:traderId", Payment.getSavedPaymentMethods);

router.post("/paypal-create-order", Payment.createPaypalOrder);
router.post("/paypal-capture", Payment.capturePaypalOrder);

module.exports = router;
