const mongoose = require("mongoose");

const TraderSchema = new mongoose.Schema(
  {
    role: {
      type: String,
      enum: ['trader']
    },
    stripeCustomerId: {
      type: String
    },
    accountNumber: {
      type: String
    },
    firstName: {
      type: String
    },
    lastName: {
      type: String
    },
    email: {
      type: String,
    },
    password: {
      type: String
    },
    companyName: {
      type: String
    },
    companyAddress: {
      type: String
    },
    address: {
      type: String
    },
    postcode: {
      type: String
    },
    city: {
      type: String
    },
    contactNumber: {
      type: String
    },
    tradingContactNumber: {
      type: String
    },
    tradingAddress: {
      type: String
    },
    currentlySellingPhones: {
      type: String
    },
    moreInformation: {
      type: String
    },
    status: {
      type: String,
      default: "inactive"
    },
    verified: {
      type: Boolean,
      default: false
    },
    allowedCOD: {
      type: Boolean,
      default: false
    },
    otp: {
      type: String
    }
  },
  {
    timestamps: true    // Add this option to enable timestamps
  }
);

module.exports = mongoose.model("Trader", TraderSchema);