const Footer = require('../models/Footer');

// Create a new footer
exports.createFooter = async (req, res) => {
    try {
        const footer = new Footer(req.body);
        await footer.save();
        res.status(201).json(footer);
    } catch (error) {
        res.status(400).json({ message: error.message });
    }
};

// Get all footers
exports.getFooters = async (req, res) => {
    try {
        const footers = await Footer.find();
        res.status(200).json(footers);
    } catch (error) {
        res.status(500).json({ message: error.message });
    }
};

// Get a single footer by ID
exports.getFooterById = async (req, res) => {
    try {
        const footer = await Footer.findById(req.params.id);
        if (!footer) {
            return res.status(404).json({ message: 'Footer not found' });
        }
        res.status(200).json(footer);
    } catch (error) {
        res.status(500).json({ message: error.message });
    }
};

// Update a footer by ID
exports.updateFooter = async (req, res) => {
    try {
        const footer = await Footer.findByIdAndUpdate(req.params.id, req.body, { new: true, runValidators: true });
        if (!footer) {
            return res.status(404).json({ message: 'Footer not found' });
        }
        res.status(200).json(footer);
    } catch (error) {
        res.status(400).json({ message: error.message });
    }
};

// Delete a footer by ID
exports.deleteFooter = async (req, res) => {
    try {
        const footer = await Footer.findByIdAndDelete(req.params.id);
        if (!footer) {
            return res.status(404).json({ message: 'Footer not found' });
        }
        res.status(200).json({ message: 'Footer deleted successfully' });
    } catch (error) {
        res.status(500).json({ message: error.message });
    }
};
