const bcrypt = require("bcryptjs");
const jwt = require("jsonwebtoken");
const ejs = require("ejs");
const path = require("path");
const nodemailer = require('nodemailer');
const bodyParser = require('body-parser');
const server = require('../server');
const OTPController = require("./OTPController.js");
const User = require('../models/User.js');
require('dotenv').config();

// mobilebitz
// const emailConfig = {
//   user: 'booking@mobilebitz.co.uk',
//   pass: 'O45YTPA4LVRW6GUW',
// };

const emailConfig = {
  user: process.env.EMAIL_USER,
  pass: process.env.EMAIL_PASS,
};

const transporter = nodemailer.createTransport({
  // service: 'gmail',
  host: process.env.EMAIL_HOST,
  port: 465,
  secure: true,
  auth: {
    user: process.env.EMAIL_USER,
    pass: process.env.EMAIL_PASS,
  },
});


// exports.verifyUserEmail = async function (req, res) {
//   let email = req.email;
//   // console.log("start email proc", current) 
//   let GeneratedOTP = res.otp;
//   try {
//     const mailOptions = {
//       from: emailConfig.user,
//       to: email,
//       subject: 'Confirm Email',
//       html: `
//         <!DOCTYPE html>
//         <html lang="en">

//         <head>
//             <meta charset="UTF-8">
//             <meta name="viewport" content="width=device-width, initial-scale=1.0">
//             <title>Email Confirmation</title>
//             <style>
//                 body {
//                     font-family: 'Arial', sans-serif;
//                     background-color: #000;
//                     color: #fff;
//                     margin: 0;
//                     padding: 0;
//                     display: flex;
//                     align-items: center;
//                     justify-content: center;
//                     height: 100vh;
//                 }

//                 .email-container {
//                     background-color: #111;
//                     color: #fff;
//                     padding: 20px;
//                     border-radius: 10px;
//                     width: 100%;
//                     max-width: 500px;
//                     text-align: center;
//                     box-sizing: border-box;
//                 }

//                 .confirmation-text {
//                     font-size: 18px;
//                     margin-bottom: 20px;
//                 }

//                 .button {
//                     display: inline-block;
//                     padding: 10px 20px;
//                     background-color: #00ff00;
//                     color: #000;
//                     text-decoration: none;
//                     border-radius: 5px;
//                     font-weight: bold;
//                     cursor: pointer;
//                 }

//                 .button:hover {
//                     background-color: #007700;
//                 }
//             </style>
//         </head>

//         <body>
//             <div class="email-container">
//                 <h1>Email Confirmation</h1>
//                 <p class="confirmation-text">
//                     Thank you for signing up at Mobile Shop!
//                     To complete your registration, please click the button below.
//                 </p>
              

//                 <p>
//         This is your OTP,         ${GeneratedOTP} 
//                 </p>
        
//             </div>
//         </body>

//         </html>
//       `,
//     };

//     await transporter.sendMail(mailOptions);
//     console.log("email send!")
//     return 'Email sent successfully!'
//   } catch (error) {
//     console.error('Error sending email:', error);
//     res.status(500).send('Error sending email');
//   }
// };





exports.signupuseremail = async function (req, res) {
  const email = req.email;

  try {
    const mailOptions = {
      from: `"Wizard Vape Support" <${emailConfig.user}>`,
      to: email,
      subject: 'Your Wizard Vape account has been created',
      text: `Hi,

Thank you for registering at Wizard Vape. Your account has been successfully created.

Explore our wide range of vape products, flavors, and accessories today.

Login to your account: https://thewizardvape.com/login

If you have any questions, feel free to contact our support team.

Best regards,
Wizard Vape Support Team

---
Wizard Vape
47A whitegate Drive FY3 9DG Blackpool
294A Lytham Road FY1 6EY Blackpool
Support: support@thewizardvape.com
To unsubscribe, please reply with "Unsubscribe"
      `,
      html: `
        <!doctype html>
        <html lang="en-US">
        <head>
          <meta charset="utf-8">
          <title>Wizard Vape Account Created</title>
          <meta name="viewport" content="width=device-width, initial-scale=1">
          <style>
            body {
              font-family: Arial, sans-serif;
              background-color: #f4f4f4;
              color: #333;
              margin: 0;
              padding: 0;
            }
            .email-container {
              max-width: 600px;
              margin: auto;
              background: #ffffff;
              padding: 20px;
              border-radius: 6px;
              box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            }
            .header {
              text-align: center;
              padding-bottom: 20px;
            }
            .header h2 {
              color: #8f45ea;
              font-size: 22px;
            }
            .content {
              font-size: 15px;
              line-height: 1.6;
            }
            .btn {
              display: inline-block;
              margin-top: 20px;
              padding: 10px 20px;
              background-color: #8f45ea;
              color: #fff;
              text-decoration: none;
              border-radius: 30px;
              font-weight: bold;
            }
            .footer {
              font-size: 12px;
              color: #888;
              text-align: center;
              margin-top: 30px;
            }
          </style>
        </head>
        <body>
          <div class="email-container">
            <div class="header">
              <h2>Welcome to Wizard Vape</h2>
            </div>
            <div class="content">
              <p>Dear Customer,</p>
              <p>Your account has been successfully created at <strong>Wizard Vape</strong>.</p>
              <p>You now have access to exclusive products, limited-edition flavors, and expert guidance from our community.</p>
              <p>Click the button below to log in and start exploring:</p>
              <a href="https://thewizardvape.com/login" style="color: #ffffff;" class="btn">Login Now</a>
              <p>If you have any questions, feel free to reach out to our support team anytime.</p>
              <p>Thank you for joining us!</p>
            </div>
            <div class="footer">
              <p>© ${new Date().getFullYear()} Wizard Vape. All rights reserved.</p>
              <p>47A Whitegate Drive FY3 9DG</p>
              <p>294 Lytham Rd, Blackpool FY1 6EY</p>
              <p><a href="mailto:admin@thewizardvape.com">admin@thewizardvape.com</a></p>
              <p>If you no longer wish to receive emails from us, please reply with "Unsubscribe".</p>
            </div>
          </div>
        </body>
        </html>
      `
    };

    await transporter.sendMail(mailOptions);
    console.log("Email sent!");
    return 'Email sent successfully!';
  } catch (error) {
    console.error('Error sending email:', error);
    res.status(500).send('Error sending email');
  }
};





exports.sendtoadmin = async function ({ name, email, contact, message }) {
  try {
    const mailOptions = {
      from: `"Wizard Vape Website" <info@thewizardvape.com>`,
      to: 'admin@thewizardvape.com',
      subject: `New Contact Form Submission from ${name}`,
      text: `New Contact Form Submission:

Name: ${name}
Email: ${email}
Contact: ${contact}
Message:
${message}

Submitted via: https://thewizardvape.com/contact-us
      `,
      html: `<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>New Contact Submission</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #f8f8f8;
      padding: 20px;
      color: #333;
    }
    .email-container {
      background: #fff;
      padding: 20px;
      border-radius: 8px;
      max-width: 600px;
      margin: auto;
      box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }
    h2 {
      color: #8f45ea;
      margin-bottom: 20px;
    }
    .info {
      margin-bottom: 10px;
      font-size: 15px;
    }
    .label {
      font-weight: bold;
      color: #555;
    }
    .footer {
      margin-top: 30px;
      font-size: 12px;
      color: #888;
      text-align: center;
    }
  </style>
</head>
<body>
  <div class="email-container">
    <h2>New Contact Form Submission</h2>
    <div class="info"><span class="label">Name:</span> ${name}</div>
    <div class="info"><span class="label">Email:</span> ${email}</div>
    <div class="info"><span class="label">Contact Number:</span> ${contact}</div>
    <div class="info"><span class="label">Message:</span><br>${message.replace(/\n/g, '<br>')}</div>

    <div class="footer">
      Submitted via Wizard Vape Website<br>
      <a href="https://thewizardvape.com">thewizardvape.com</a>
    </div>
  </div>
</body>
</html>`
    };

    await transporter.sendMail(mailOptions);
    console.log("Admin notification email sent.");
    return true;
  } catch (error) {
    console.error('Error sending admin email:', error);
    throw error;
  }
};









exports.contactusformemail = async function (email, res) {
  try {
    const mailOptions = {
      from: `"Wizard Vape" <info@thewizardvape.com>`,
      to: email,
      subject: 'Confirmation: Message Received by Wizard Vape',
      text: `Hello,

Thank you for contacting Wizard Vape. We’ve successfully received your message and our support team will respond shortly.

Warm regards,  
Wizard Vape Support Team  
https://thewizardvape.com`,
      html: `<!DOCTYPE html>
        <html lang="en">
        <head>...</head>
<body>
  <div class="container">
    <div class="header">
      <h2>We’ve Received Your Message</h2>
    </div>
    <div class="content">
      <p>Hello,</p>
      <p>Thank you for contacting <strong>Wizard Vape</strong>.</p>
      <p>We’ve successfully received your message and one of our support team members will respond as soon as possible.</p>
      <p>If your query is urgent, you can also email us directly at <a href="mailto:info@thewizardvape.com">info@thewizardvape.com</a>.</p>
      <p>Meanwhile, feel free to explore our latest products and updates at <a href="https://thewizardvape.com" target="_blank">thewizardvape.com</a>.</p>
      <p>Thank you for reaching out.</p>
    </div>
    <div class="footer">
      <p>© ${new Date().getFullYear()} Wizard Vape. All rights reserved.</p>
      <p>47A whitegate Drive FY3 9DG Blackpool</p>
      <p>294A Lytham Road FY1 6EY Blackpool</p>
      <p>Contact: <a href="mailto:info@thewizardvape.com">info@thewizardvape.com</a></p>
      <p>If you wish to stop receiving emails from us, please reply with "Unsubscribe".</p>
    </div>
  </div>
</body>

        </html>`
    };

    await transporter.sendMail(mailOptions);
    console.log("Contact acknowledgment email sent.");
    return true;
  } catch (error) {
    console.error('Error sending email:', error);
    throw error; // Let the caller (controller) handle the error
  }
};




exports.ordersend = async function (req , res){
  try{
    console.log("abc====", req.body.email)
    const { message , email } = req.body;
    const mailOptions = {
      from: emailConfig.user,
      to: `${req.body.email}, admin@thewizardvape.com`,
      subject: 'Your New Order On Wizard Vape',
      html: `
      <div style="max-width:700px; margin:0 auto; font-family:sans-serif; border:1px solid #ddd; padding:30px;">
        <div style="text-align:center;">
          <h2 style="color:#30acd2;">🧾 Wizard Vape - Order Summary</h2>
        </div>

        <div style="background:#f9f9f9; padding:20px; border-radius:8px; margin-top:20px;">
          <pre style="white-space:pre-wrap; word-wrap:break-word; font-size:14px; line-height:1.6;">${message}</pre>
        </div>

        <div style="margin-top:30px; text-align:center;">
          <p style="font-size:13px; color:#888;">This email was generated automatically by Wizard Vape’s ordering system.</p>
        </div>
      </div>
      `,
    };

    await transporter.sendMail(mailOptions);


    console.log("Order acknowledgment email sent."); 
    res.status(200).json({ success: true, message: "Email sent successfully" });

  }
  catch (error) {
    console.error('Error sending email:', error);
    res.status(500).send('Error sending email');
  }
}



exports.postNew = async function (req, res) {
  try {
    const { color, images, depth, email, length, message, name, phNum, productInfo, units, width, stock } = req.body;

    const mailOptions = {
      from: emailConfig.user,
      to: "starcmarcus5@gmail.com",
      subject: 'Your New Order On Pentagon Packaging',
      html: `
     <div style="max-width: 650px; margin: 0px auto; padding: 50px 0px">
      <table style="width: 100%">
        <tr>
          <td style="padding: 0px 10px; text-align: center">
            <img
              src="."
              alt="Pentagon logo"
              height="130px"
              style="margin-bottom: 30px"
            />
          </td>
        </tr>
        <tr>
          <td>
            <center>
              <h1 style="margin-bottom: 15px; color: #30acd2">
                Hi! Pentagon Packaging Team
              </h1>
            </center>
          </td>
        </tr>
        <td><h3>Your New Order Information is:</h3></td>
        <tr></tr>
        <tr>
          <td>
            <div
              style="
                border: 1px solid #ddd;
                padding: 15px;
                border-radius: 5px;
                background-color: #f9f9f9;
              "
            >
              <h2>Information:</h2>
              
            </div>
          </td>
        </tr>
        <tr>
          <td>
            <a
              href="https://www.pentagonpackaging.com/"
              target="_blank"
              style="
                display: block;
                margin: 15px 0px;
                background-color: #30acd2;
                width: 175px;
                text-align: center;
                padding: 15px 25px;
                border-radius: 5px;
                color: white !important;
                text-decoration: none;
              "
              >Visit Website</a
            >
          </td>
        </tr>
        <tr>
          <td>
            <p style="margin-top: 20px">Regards,</p>
            <p>PentagonePackaging Team</p>
          </td>
        </tr>
        <tr>
          <td>
            <p style="margin-top: 30px; text-align: center">
              <small style="font-size: 12px"
                >Write us at
                <a href="mailto:--">info@pentagonpackaging.pk</a> in
                case of any inconvenience.</small
              >
            </p>
            <p style="text-align: center">
              <small style="font-size: 12px"
                >&copy; 2023 - All rights reserved by PentagonPackaging.com</small
              >
            </p>
          </td>
        </tr>
      </table>
    </div>

      `,
    };

    await transporter.sendMail(mailOptions);

    res.status(200).send('Email sent successfully!');
  } catch (error) {
    console.error('Error sending email:', error);
    res.status(500).send('Error sending email');
  }
};

exports.NewOrder = async function (session, req, res) {
  // console.log("session========>>", session);
  console.log("req========>>", req);
  const currentDate = new Date();
  const month = currentDate.toLocaleString('default', { month: 'long' });
  const date = currentDate.getDate();
  let hours = currentDate.getHours();
  const ampm = hours >= 12 ? 'pm' : 'am';
  hours = hours % 12;
  hours = hours ? hours : 12; // Handle midnight (12:00 am)
  const minutes = currentDate.getMinutes();
  const timeString = `${hours}:${minutes < 10 ? '0' : ''}${minutes} ${ampm}`;

  const formattedDateTime = `${month} ${date} ${timeString}`;
  try {
    // console.log("abc=====", req.customerEmail);

    // const email = req.customerEmail;
    const email = session.customer_details.email;
    if (!email) {
      const user = await User.findOne({ _id: req.userid });
      email = user.email;
    }
    const mailOptions = {
      from: emailConfig.user,
      to: email,
      subject: `${process.env.BUSINESS_NAME} || Your Order Has Been Placed Successfully`,
      html: `  
<body> 
<table  style="width:100%;max-width:100%;" width="100%" cellspacing="0" cellpadding="0" border="0" align="center">
<tr>
               <td bgcolor="#F4F4F4" align="center">
             
                   <!--container-->
                    <table class="row" style="width:600px;max-width:600px;" width="600" cellspacing="0" cellpadding="0" border="0" align="center">
                        <tr><td bgcolor="grey" align="center">
                            
                            <!--wrapper-->
                            <table class="row" style="width:540px;max-width:540px;" width="540" cellspacing="0" cellpadding="0" border="0" align="center">
                            <tr><td class="container-padding" align="center">
                                
                              
                                
                                <!-- content container -->
                                <table width="540" border="0" cellpadding="0" cellspacing="0" align="center" class="row" style="width:540px;max-width:540px;">
                                    <tr><td align="center">
                                        
                                    <!-- content -->    
                                      <table border="0" width="100%" cellpadding="0" cellspacing="0" align="center" style="width:100%; max-width:100%;">
                                          <tr><td height="25">&nbsp;</td></tr> 
                                     <tr><td>
                                         <table border="0" width="100%" cellpadding="0" cellspacing="0" align="center">
                                         <tr>
                                             <td width="80" align="left">
                                             <img width="120" style="display:block;;max-width:120px;" alt="img" src="https://mobilebitz.co.uk/logo/logo.png">
                                             </td>
                                             <td>&nbsp;</td>
                                             <td align="right" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #ffffff;"><a href="https://accessories.mobilebitz.co.uk/Faqs" target="_blank" style="color: #ffffff">Faq's</a></td>
                                             </tr>
                                         </table>
                                         </td></tr>
                                          <tr><td height="25">&nbsp;</td></tr> 
                                        </table>
                                        
                                        </td></tr>
                                </table>
                                
                              
                                
                                </td></tr>
                            </table>
                            
                            </td></tr>
               </table>
             
             </td>
               </tr>
        </table>
        <!--module-->
<table  style="width:100%;max-width:100%;" width="100%" cellspacing="0" cellpadding="0" border="0" align="center">
<tr>
               <td bgcolor="#F4F4F4" align="center">
             
                   <!--container-->
                    <table class="row" style="width:600px;max-width:600px;" width="600" cellspacing="0" cellpadding="0" border="0" align="center">
                        <tr><td bgcolor="#f6f6f4" align="center">
                            
                            <!--wrapper-->
                            <table class="row" style="width:540px;max-width:540px;" width="540" cellspacing="0" cellpadding="0" border="0" align="center">
                            <tr><td class="container-padding" align="center">
                                
                              
                                
                                <!-- content container -->
                                <table width="540" border="0" cellpadding="0" cellspacing="0" align="center" class="row" style="width:540px;max-width:540px;">
                                    <tr><td align="center">
                                        
                                    <!-- content -->    
                                      <table border="0" width="100%" cellpadding="0" cellspacing="0" align="center" style="width:100%; max-width:100%;">
                                          <tr><td height="30">&nbsp;</td></tr> 
                                     <tr><td align="center"><img width="100" style="display:block;;max-width:100px;" alt="img" src="http://emailmug.com/premium-template/emailpaws/notif/cr.png"></td></tr>
                                     <tr><td height="20">&nbsp;</td></tr>
                             <tr><td align="center" style="font-family:'Josefin Sans', Arial, Helvetica, sans-serif;font-size: 30px;color: #282828;">New Order Placed</td></tr>
                                          <tr><td height="18">&nbsp;</td></tr>
                             <tr><td align="center" style="font-family:'Josefin Sans', Arial, Helvetica, sans-serif;font-size: 24px;color: #282828;line-height: 25px;">Your Order has been placed successfully,
                                 <br><strong><span style="font-size: 15px">${formattedDateTime}</span></strong> </td></tr>
                            <tr><td height="18">&nbsp;</td></tr>
                             <tr><td align="center" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 15px;color: #282828;">Hurry up fulfill your customer order and don't let them wait.</td></tr>
                                          <tr><td height="25">&nbsp;</td></tr>
                             <tr><td align="center">
                                 
                                      <!--button-->
                                              <table border="0" bgcolor="#9c8563" cellpadding="0" cellspacing="0"><tr>
                           
                            <td  align="center" height="40" width="170" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 13px;color: #ffffff;font-weight: 600;letter-spacing: 0.5px;">
                            
                            
                                <a href="https://accessories.mobilebitz.co.uk/UserDashboad" target="_blank" style="color: #ffffff">VIEW ORDER</a>
                            </td>
                           
                            </tr></table>
                                 
                                 </td></tr>
                                         
                                          <tr><td height="30">&nbsp;</td></tr> 
                                        </table>
                                        
                                        </td></tr>
                                </table>
                                
                              
                                
                                </td></tr>
                            </table>
                            
                            </td></tr>
               </table>
             
             </td>
               </tr>
        </table>
                <!--module-->
<table  style="width:100%;max-width:100%;" width="100%" cellspacing="0" cellpadding="0" border="0" align="center">
<tr>
               <td bgcolor="#F4F4F4" align="center">
             
                   <!--container-->
                    <table class="row" style="width:600px;max-width:600px;" width="600" cellspacing="0" cellpadding="0" border="0" align="center">
                        <tr><td bgcolor="#FFFFFF" align="center">
                            
                            <!--wrapper-->
                            <table class="row" style="width:540px;max-width:540px;" width="540" cellspacing="0" cellpadding="0" border="0" align="center">
                            <tr><td class="container-padding" align="center">
                                
                              
                                
                                <!-- content container -->
                                <table width="540" border="0" cellpadding="0" cellspacing="0" align="center" class="row" style="width:540px;max-width:540px;">
                                    <tr><td align="center">
                                        
                                    <!-- content -->    
                                      <table border="0" width="100%" cellpadding="0" cellspacing="0" align="center" style="width:100%; max-width:100%;">
                                          <tr><td height="30">&nbsp;</td></tr> 
                                     
                             <tr><td>
                                 <table border="0" width="100%" cellpadding="0" cellspacing="0" align="center">
                                 <tr>
                                     <td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 13px;color: #282828;">Order Number #${req.orderNumber}</td>
                                     <td width="30">&nbsp;</td>
                                     <td align="right" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 13px;color: #282828;">Items Price</td>
                                     </tr>
                                 </table>
                                 </td></tr>
                             <tr><td style="line-height: 8px;height: 8px;font-size: 0px;">&nbsp;</td></tr>
                             <tr><td bgcolor="#e7e6e2" style="line-height: 8px;height: 8px;font-size: 0px;">&nbsp;</td></tr>
                             <tr><td height="20">&nbsp;</td></tr>
                             <tr><td>
                                  ${req.productInfo.map((product, index) => `
    <table key=${index} border="0" width="100%" cellpadding="0" cellspacing="0" align="center"> 
      <tr>
        <td style="font-family:'Josefin Sans', Arial, Helvetica, sans-serif;font-size: 18px;color: #282828;line-height: 21px;">${product.subsubcatagory}</td>
        <td width="20">&nbsp;</td>
        <td width="250">
          <table border="0" width="100%" cellpadding="0" cellspacing="0"> 
            <tr><td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;line-height: 21px;">Quantity: ${product.quantity}</td></tr>
          </table>
        </td>
        <td>&nbsp;</td>
        <td align="right" width="60">
          <table border="0" width="60" cellpadding="0" cellspacing="0">
            <tr><td align="right" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 18px;color: #282828;"> ₤ ${product.productPrice}</td></tr>
          </table>
        </td>
      </tr>
    </table>
  `).join('')}
                                 </td></tr>
                                          <tr><td height="20" style="border-bottom: 1px solid #e0e0e0">&nbsp;</td></tr> 
                                          <tr><td height="20">&nbsp;</td></tr>
                                             <tr><td>
                               
                                 </td></tr>
                                          <tr><td height="20">&nbsp;</td></tr> 
                                           <tr><td bgcolor="#e7e6e2" style="line-height: 8px;height: 8px;font-size: 0px;">&nbsp;</td></tr>
                                          <tr><td height="30">&nbsp;</td></tr>
                                          <tr><td align="right">
                                              
                                              <table border="0" width="280" cellpadding="0" cellspacing="0">
                                                  <tr>
                                                      <td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;line-height: 24px;">Subtotal</td>
                                                      <td>&nbsp;</td>
                                                      <td align="right" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;"> ₤ ${session.amount_subtotal / 100}</td>
                                                  </tr>
                                                  <tr>
                                                      <td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;line-height: 24px;">Delivery Charges</td>
                                                      <td>&nbsp;</td>
                                                     <td align="right" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;"> ₤ ${req.deliverycharges}</td>
                                                  </tr>
                                                  
                                                  <tr>
                                                      <td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;line-height: 24px;">Discount</td>
                                                      <td>&nbsp;</td>
                                                     <td align="right" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;text-decoration: ">  ₤ ${req.discount}</td>
                                                  </tr>
                                                  <tr>
                                                      <td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 18px;color: #282828;font-weight: 600;line-height: 24px;">Total</td>
                                                      <td>&nbsp;</td>
                                                      <td align="right" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 18px;color: #282828;"><strong>  ₤ ${session.amount_subtotal / 100}</strong></td>
                                                  </tr>
                                                  <tr>
                                                      <td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;line-height: 24px;">&nbsp;</td>
                                                      <td>&nbsp;</td> 
                                                  </tr>
                                              </table>
                                              </td></tr>
                                             <tr><td height="30">&nbsp;</td></tr> 
                                           <tr><td bgcolor="#e7e6e2" style="line-height: 8px;height: 8px;font-size: 0px;">&nbsp;</td></tr>
                                          <tr><td style="line-height: 15px;height: 15px;font-size: 0px;">&nbsp;</td></tr>
                                        </table>
                                        
                                        </td></tr>
                                </table>
                                
                              
                                
                                </td></tr>
                            </table>
                            
                            </td></tr>
               </table>
             
             </td>
               </tr>
        </table>
            
        <!--module-->
<table  style="width:100%;max-width:100%;" width="100%" cellspacing="0" cellpadding="0" border="0" align="center">
<tr>
               <td bgcolor="#F4F4F4" align="center">
             
                   <!--container-->
                    <table class="row" style="width:600px;max-width:600px;" width="600" cellspacing="0" cellpadding="0" border="0" align="center">
                        <tr><td bgcolor="#FFFFFF" align="center">
                            
                            <!--wrapper-->
                            <table class="row" style="width:540px;max-width:540px;" width="540" cellspacing="0" cellpadding="0" border="0" align="center">
                            <tr><td class="container-padding" align="center">
                                
                              
                                
                                <!-- content container -->
                                <table width="540" border="0" cellpadding="0" cellspacing="0" align="center" class="row" style="width:540px;max-width:540px;">
                                    <tr><td align="center">
                                        
                                    <!-- content -->    
                                      <table border="0" width="100%" cellpadding="0" cellspacing="0" align="center" style="width:100%; max-width:100%;">
                                          <tr><td style="line-height: 15px;height: 15px;font-size: 0px;">&nbsp;</td></tr> 
                                     
                             
                                          <tr><td align="center">
                                        
                                        <!--[if (gte mso 9)|(IE)]><table border="0" cellpadding="0" cellspacing="0"><tr><td><![endif]-->
                                        
                                    <!-- column -->    
                                        <table class="row" style="width:260px;max-width:260px;" width="260" cellspacing="0" cellpadding="0" border="0" align="left">
                                        <tr><td align="center">
                                            
                                            <!-- content -->
                                            <table width="260" style="width:260px;max-width:260px;" cellspacing="0" cellpadding="0" border="0" align="center">
                                                
                                                <tr><td align="center" bgcolor="#F5F5F3">
                                                    
                                                    <table border="0" width="200" cellpadding="0" cellspacing="0" align="center">
                                                    <tr><td height="30">&nbsp;</td></tr>
                                                        
                                                        
                                                    <tr><td style="font-family:'Josefin Sans', Arial, Helvetica, sans-serif;font-size: 18px;color: #282828;">Billing Address</td></tr>
                                                    <tr><td height="18">&nbsp;</td></tr>
                                                    <tr><td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 13px;color: #282828;line-height: 22px;">${session.payment_method_types[0]} <br> ${session.payment_status} <br> ${req.paymentType}</td></tr>
                                                    <tr><td height="30">&nbsp;</td></tr> 
                                                        
                                                        
                                                    <tr><td height="30">&nbsp;</td></tr>
                                                    </table>
                                                    
                                                    </td></tr>
                                                
                                               
                                              
                                            </table>
                                            
                                            </td></tr>
                                        </table>
                                        
                                        <!--[if (gte mso 9)|(IE)]></td><td><![endif]-->
                                        
                                        <!-- gap -->
                                        <table class="row" style="width:50px;max-width:50px;" width="50" cellspacing="0" cellpadding="0" border="0" align="left"><tr><td height="30"></td></tr></table>
                                        
                                         <!--[if (gte mso 9)|(IE)]></td><td><![endif]-->
                                        
                                         <!-- column -->    
                                        <table class="row" style="width:230px;max-width:230px;" width="230" cellspacing="0" cellpadding="0" border="0" align="right">
                                        <tr><td align="center">
                                            
                                            <!-- content -->
                                         <table width="230" style="width:230px;max-width:230px;" cellspacing="0" cellpadding="0" border="0" align="center">
                                                
                                                <tr><td height="30">&nbsp;</td></tr>
                                             <tr><td style="font-family:'Josefin Sans', Arial, Helvetica, sans-serif;font-size: 18px;color: #282828;">Shipping Address</td></tr>
                                                    <tr><td height="18">&nbsp;</td></tr>
                                                    <tr><td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 13px;color: #282828;line-height: 22px;"> ${req.customerAddress} <br>${req.postalCode}<br>UK</td></tr>
                                                    <tr><td height="30">&nbsp;</td></tr> 
                                            </table>
                                            
                                            </td></tr>
                                        </table>
                                        
                                  
                                        
                                      
                                        
                                        <!--[if (gte mso 9)|(IE)]></td></tr></table><![endif]-->
                                        </td></tr>
                                          <tr><td height="30">&nbsp;</td></tr> 
                                        </table>
                                        
                                        </td></tr>
                                </table>
                                
                              
                                
                                </td></tr>
                            </table>
                            
                            </td></tr>
               </table>
             
             </td>
               </tr>
        </table>
          <!--module-->
<table  style="width:100%;max-width:100%;" width="100%" cellspacing="0" cellpadding="0" border="0" align="center">
<tr>
               <td bgcolor="#F4F4F4" align="center">
             
                   <!--container-->
                    <table class="row" style="width:600px;max-width:600px;" width="600" cellspacing="0" cellpadding="0" border="0" align="center">
                        <tr><td bgcolor="#282828" align="center">
                            
                            <!--wrapper-->
                            <table class="row" style="width:540px;max-width:540px;" width="540" cellspacing="0" cellpadding="0" border="0" align="center">
                            <tr><td class="container-padding" align="center">
                                
                              
                                
                                <!-- content container -->
                                <table width="540" border="0" cellpadding="0" cellspacing="0" align="center" class="row" style="width:540px;max-width:540px;">
                                    <tr><td align="center">
                                        
                                    <!-- content -->    
                                      <table border="0" width="100%" cellpadding="0" cellspacing="0" align="center" style="width:100%; max-width:100%;">
                                          <tr><td height="40">&nbsp;</td></tr> 
                                     
                              <tr><td align="center" style="font-family:'Josefin Sans', Arial, Helvetica, sans-serif;font-size: 18px;color: #dadada;font-weight: 400;">Get in Touch</td></tr>
                           
                                        <tr><td height="20">&nbsp;</td></tr>
                                           <tr><td>
                                              
                                              <table cellspacing="0" cellpadding="0" border="0" align="center">
                                              <tr>
                                                  <td width="25">
  <a href="https://www.facebook.com/mobilebitz?mibextid=kFxxJD">
    <img width="25" style="display:block; max-width:25px;" src="http://emailmug.com/premium-template/emailpaws/notif/fb.png" alt="Facebook">
  </a>
</td>
<td width="10">&nbsp;</td>
<td width="25">
  <a href="https://www.instagram.com/mobile_bitz_official?igsh=MTE3OWozc2o2aTFsZA==">
    <img width="25" style="display:block; max-width:25px;" src="http://emailmug.com/premium-template/emailpaws/notif/in.png" alt="LinkedIn">
  </a>
</td>

                                                  <td width="10">&nbsp;</td>
                                                 
                                                  </tr>
                                              </table>
                                              
                                              </td></tr>
                                        <tr><td height="20">&nbsp;</td></tr>
                                        <tr><td align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 19px;">This email was sent to : ${req.customerEmail}<br>
                                           This email is for your information. If you have any questions or concerns, please don't hesitate to contact us.<br>
                                            For any questions please send to booking@mobilebitz.co.uk
 </td></tr>
                                          <tr><td>&nbsp;</td></tr>
                                          <tr><td align="center">
                                              
                                              <table cellspacing="0" cellpadding="0" border="0">
                                              <tr>
                                                  <td align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;text-decoration: underline"><a href="https://accessories.mobilebitz.co.uk/Cookies" target="_blank" style="color: #dadada">GDPR consent</a></td>
                                                  <td width="20" align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;">|</td>
                                                  <td align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;text-decoration: underline"><a href="https://accessories.mobilebitz.co.uk/Terms" target="_blank" style="color: #dadada">Terms and Conditions</a></td>
                                                  <td width="20" align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;">|</td>
                                                  <td align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;text-decoration: underline"><a href="https://accessories.mobilebitz.co.uk/Privacy" target="_blank" style="color: #dadada">Privacy Policy</a></td>                                                  <td align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;text-decoration: underline"><a href="http://www.example.com" target="_blank" style="color: #dadada">Privacy Policy</a></td>
                                                  <td width="20" align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;">|</td>
                                                  <td align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;text-decoration: underline"><a href="https://accessories.mobilebitz.co.uk/Faqs" target="_blank" style="color: #dadada">Faqs</a></td>                                                  <td align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;text-decoration: underline"><a href="http://www.example.com" target="_blank" style="color: #dadada">Privacy Policy</a></td>
                                                  </tr>
                                              </table>
                                              
                                              </td></tr>
                                          <tr><td height="40">&nbsp;</td></tr> 
                                        </table>
                                        
                                        </td></tr>
                                </table>
                                
                              
                                
                                </td></tr>
                            </table>
                            
                            </td></tr>
               </table>
             
             </td>
               </tr>
        </table>
    </body>


      `,
    };
    await transporter.sendMail(mailOptions);
    console.log("success user")
  } catch (error) {
    console.error('Error sending email:', error);
    res.status(500).send('Error sending email');
  }
};





exports.MailToAdmin = async function (session, req, res) {
  console.log("session=====", session);
  const currentDate = new Date();
  const month = currentDate.toLocaleString('default', { month: 'long' });
  const date = currentDate.getDate();
  let hours = currentDate.getHours();
  const ampm = hours >= 12 ? 'pm' : 'am';
  hours = hours % 12;
  hours = hours ? hours : 12; // Handle midnight (12:00 am)
  const minutes = currentDate.getMinutes();
  const timeString = `${hours}:${minutes < 10 ? '0' : ''}${minutes} ${ampm}`;



  const formattedDateTime = `${month} ${date} ${timeString}`;
  try {
    const email = req.customerEmail;
    const mailOptions = {
      from: emailConfig.user,
      to: process.env.ADMIN_MAIL,
      // to: req.customerEmail,
      subject: `${process.env.BUSINESS_NAME} || New customer to Buy a Product`,
      html: `  
<body> 
<table  style="width:100%;max-width:100%;" width="100%" cellspacing="0" cellpadding="0" border="0" align="center"> 
<tr>
               <td bgcolor="#F4F4F4" align="center">
             
                   <!--container-->
                    <table class="row" style="width:600px;max-width:600px;" width="600" cellspacing="0" cellpadding="0" border="0" align="center">
                        <tr><td bgcolor="grey" align="center">
                            
                            <!--wrapper-->
                            <table class="row" style="width:540px;max-width:540px;" width="540" cellspacing="0" cellpadding="0" border="0" align="center">
                            <tr><td class="container-padding" align="center">
                                
                              
                                
                                <!-- content container -->
                                <table width="540" border="0" cellpadding="0" cellspacing="0" align="center" class="row" style="width:540px;max-width:540px;">
                                    <tr><td align="center">
                                        
                                    <!-- content -->    
                                      <table border="0" width="100%" cellpadding="0" cellspacing="0" align="center" style="width:100%; max-width:100%;">
                                          <tr><td height="25">&nbsp;</td></tr> 
                                     <tr><td>
                                         <table border="0" width="100%" cellpadding="0" cellspacing="0" align="center">
                                         <tr>
                                             <td width="80" align="left">
                                             <img width="120" style="display:block;;max-width:120px;" alt="img" src="https://mobilebitz.co.uk/logo/logo.png">
                                             </td>
                                             <td>&nbsp;</td>
                                             <td align="right" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #ffffff;"><a href="https://accessories.mobilebitz.co.uk/Faqs" target="_blank" style="color: #ffffff">Faq's</a></td>
                                             </tr>
                                         </table>
                                         </td></tr>
                                          <tr><td height="25">&nbsp;</td></tr> 
                                        </table>
                                        
                                        </td></tr>
                                </table>
                                
                              
                                
                                </td></tr>
                            </table>
                            
                            </td></tr>
               </table>
             
             </td>
               </tr>
        </table>
        <!--module-->
<table  style="width:100%;max-width:100%;" width="100%" cellspacing="0" cellpadding="0" border="0" align="center">
<tr>
               <td bgcolor="#F4F4F4" align="center">
             
                   <!--container-->
                    <table class="row" style="width:600px;max-width:600px;" width="600" cellspacing="0" cellpadding="0" border="0" align="center">
                        <tr><td bgcolor="#f6f6f4" align="center">
                            
                            <!--wrapper-->
                            <table class="row" style="width:540px;max-width:540px;" width="540" cellspacing="0" cellpadding="0" border="0" align="center">
                            <tr><td class="container-padding" align="center">
                                
                              
                                
                                <!-- content container -->
                                <table width="540" border="0" cellpadding="0" cellspacing="0" align="center" class="row" style="width:540px;max-width:540px;">
                                    <tr><td align="center">
                                        
                                    <!-- content -->    
                                      <table border="0" width="100%" cellpadding="0" cellspacing="0" align="center" style="width:100%; max-width:100%;">
                                          <tr><td height="30">&nbsp;</td></tr> 
                                     <tr><td align="center"><img width="100" style="display:block;;max-width:100px;" alt="img" src="http://emailmug.com/premium-template/emailpaws/notif/cr.png"></td></tr>
                                     <tr><td height="20">&nbsp;</td></tr>
                             <tr><td align="center" style="font-family:'Josefin Sans', Arial, Helvetica, sans-serif;font-size: 30px;color: #282828;">New Order Placed</td></tr>
                                          <tr><td height="18">&nbsp;</td></tr>
                             <tr><td align="center" style="font-family:'Josefin Sans', Arial, Helvetica, sans-serif;font-size: 24px;color: #282828;line-height: 25px;">A Customer Placed a order on MobileBitz.
                                 <br><strong><span style="font-size: 15px">${formattedDateTime}</span></strong> </td></tr>
                            <tr><td height="18">&nbsp;</td></tr>
                             <tr><td align="center" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 15px;color: #282828;">Hurry up fulfill your customer order and don't let them wait.</td></tr>
                                          <tr><td height="25">&nbsp;</td></tr>
                             <tr><td align="center">
                                 
                                      <!--button-->
                                              <table border="0" bgcolor="#9c8563" cellpadding="0" cellspacing="0"><tr>
                           
                            <td  align="center" height="40" width="170" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 13px;color: #ffffff;font-weight: 600;letter-spacing: 0.5px;">
                            
                            
                                <a href="https://backoffice.mobilebitz.co.uk/AllOrders" target="_blank" style="color: #ffffff">VIEW ORDER</a>
                            </td>
                           
                            </tr></table>
                                 
                                 </td></tr>
                                         
                                          <tr><td height="30">&nbsp;</td></tr> 
                                        </table>
                                        
                                        </td></tr>
                                </table>
                                
                              
                                
                                </td></tr>
                            </table>
                            
                            </td></tr>
               </table>
             
             </td>
               </tr>
        </table>
                <!--module-->
<table  style="width:100%;max-width:100%;" width="100%" cellspacing="0" cellpadding="0" border="0" align="center">
<tr>
               <td bgcolor="#F4F4F4" align="center">
             
                   <!--container-->
                    <table class="row" style="width:600px;max-width:600px;" width="600" cellspacing="0" cellpadding="0" border="0" align="center">
                        <tr><td bgcolor="#FFFFFF" align="center">
                            
                            <!--wrapper-->
                            <table class="row" style="width:540px;max-width:540px;" width="540" cellspacing="0" cellpadding="0" border="0" align="center">
                            <tr><td class="container-padding" align="center">
                                
                              
                                
                                <!-- content container -->
                                <table width="540" border="0" cellpadding="0" cellspacing="0" align="center" class="row" style="width:540px;max-width:540px;">
                                    <tr><td align="center">
                                        
                                    <!-- content -->    
                                      <table border="0" width="100%" cellpadding="0" cellspacing="0" align="center" style="width:100%; max-width:100%;">
                                          <tr><td height="30">&nbsp;</td></tr> 
                                     
                             <tr><td>
                                 <table border="0" width="100%" cellpadding="0" cellspacing="0" align="center">
                                 <tr>
                                     <td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 13px;color: #282828;">Order Number #${req.orderNumber}</td>
                                     <td width="30">&nbsp;</td>
                                     <td align="right" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 13px;color: #282828;">Items Price</td>
                                     </tr>
                                 </table>
                                 </td></tr>
                             <tr><td style="line-height: 8px;height: 8px;font-size: 0px;">&nbsp;</td></tr>
                             <tr><td bgcolor="#e7e6e2" style="line-height: 8px;height: 8px;font-size: 0px;">&nbsp;</td></tr>
                             <tr><td height="20">&nbsp;</td></tr>
                             <tr><td>
                                  ${req.productInfo.map((product, index) => `
    <table key=${index} border="0" width="100%" cellpadding="0" cellspacing="0" align="center"> 
      <tr>
        <td style="font-family:'Josefin Sans', Arial, Helvetica, sans-serif;font-size: 18px;color: #282828;line-height: 21px;">${product.subsubcatagory}</td>
        <td width="20">&nbsp;</td>
        <td width="250">
          <table border="0" width="100%" cellpadding="0" cellspacing="0"> 
            <tr><td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;line-height: 21px;">Quantity: ${product.quantity}</td></tr>
          </table>
        </td>
        <td>&nbsp;</td>
        <td align="right" width="60">
          <table border="0" width="60" cellpadding="0" cellspacing="0">
            <tr><td align="right" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 18px;color: #282828;"> ₤ ${product.productPrice}</td></tr>
          </table>
        </td>
      </tr>
    </table>
  `).join('')}
                                 </td></tr>
                                          <tr><td height="20" style="border-bottom: 1px solid #e0e0e0">&nbsp;</td></tr> 
                                          <tr><td height="20">&nbsp;</td></tr>
                                             <tr><td>
                               
                                 </td></tr>
                                          <tr><td height="20">&nbsp;</td></tr> 
                                           <tr><td bgcolor="#e7e6e2" style="line-height: 8px;height: 8px;font-size: 0px;">&nbsp;</td></tr>
                                          <tr><td height="30">&nbsp;</td></tr>
                                          <tr><td align="right">
                                              
                                              <table border="0" width="280" cellpadding="0" cellspacing="0">
                                                  <tr>
                                                      <td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;line-height: 24px;">Subtotal</td>
                                                      <td>&nbsp;</td>
                                                      <td align="right" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;"> ₤ ${session.amount_subtotal / 100}</td>
                                                  </tr>
                                                  <tr>
                                                      <td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;line-height: 24px;">Delivery Charges</td>
                                                      <td>&nbsp;</td>
                                                     <td align="right" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;"> ₤ ${req.deliverycharges}</td>
                                                  </tr>
                                                  
                                                  <tr>
                                                      <td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;line-height: 24px;">Discount</td>
                                                      <td>&nbsp;</td>
                                                     <td align="right" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;text-decoration: ">  ₤ ${req.discount}</td>
                                                  </tr>
                                                  <tr>
                                                      <td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 18px;color: #282828;font-weight: 600;line-height: 24px;">Total</td>
                                                      <td>&nbsp;</td>
                                                      <td align="right" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 18px;color: #282828;"><strong>  ₤ ${session.amount_subtotal / 100}</strong></td>
                                                  </tr>
                                                  <tr>
                                                      <td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;line-height: 24px;">&nbsp;</td>
                                                      <td>&nbsp;</td> 
                                                  </tr>
                                              </table>
                                              </td></tr>
                                             <tr><td height="30">&nbsp;</td></tr> 
                                           <tr><td bgcolor="#e7e6e2" style="line-height: 8px;height: 8px;font-size: 0px;">&nbsp;</td></tr>
                                          <tr><td style="line-height: 15px;height: 15px;font-size: 0px;">&nbsp;</td></tr>
                                        </table>
                                        
                                        </td></tr>
                                </table>
                                
                              
                                
                                </td></tr>
                            </table>
                            
                            </td></tr>
               </table>
             
             </td>
               </tr>
        </table>
            
        <!--module-->
<table  style="width:100%;max-width:100%;" width="100%" cellspacing="0" cellpadding="0" border="0" align="center">
<tr>
               <td bgcolor="#F4F4F4" align="center">
             
                   <!--container-->
                    <table class="row" style="width:600px;max-width:600px;" width="600" cellspacing="0" cellpadding="0" border="0" align="center">
                        <tr><td bgcolor="#FFFFFF" align="center">
                            
                            <!--wrapper-->
                            <table class="row" style="width:540px;max-width:540px;" width="540" cellspacing="0" cellpadding="0" border="0" align="center">
                            <tr><td class="container-padding" align="center">
                                
                              
                                
                                <!-- content container -->
                                <table width="540" border="0" cellpadding="0" cellspacing="0" align="center" class="row" style="width:540px;max-width:540px;">
                                    <tr><td align="center">
                                        
                                    <!-- content -->    
                                      <table border="0" width="100%" cellpadding="0" cellspacing="0" align="center" style="width:100%; max-width:100%;">
                                          <tr><td style="line-height: 15px;height: 15px;font-size: 0px;">&nbsp;</td></tr> 
                                     
                             
                                          <tr><td align="center">
                                        
                                        <!--[if (gte mso 9)|(IE)]><table border="0" cellpadding="0" cellspacing="0"><tr><td><![endif]-->
                                        
                                    <!-- column -->    
                                        <table class="row" style="width:260px;max-width:260px;" width="260" cellspacing="0" cellpadding="0" border="0" align="left">
                                        <tr><td align="center">
                                            
                                            <!-- content -->
                                            <table width="260" style="width:260px;max-width:260px;" cellspacing="0" cellpadding="0" border="0" align="center">
                                                
                                                <tr><td align="center" bgcolor="#F5F5F3">
                                                    
                                                    <table border="0" width="200" cellpadding="0" cellspacing="0" align="center">
                                                    <tr><td height="30">&nbsp;</td></tr>
                                                        
                                                        
                                                    <tr><td style="font-family:'Josefin Sans', Arial, Helvetica, sans-serif;font-size: 18px;color: #282828;">Billing Address</td></tr>
                                                    <tr><td height="18">&nbsp;</td></tr>
                                                    <tr><td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 13px;color: #282828;line-height: 22px;">${session.payment_method_types[0]} <br> ${session.payment_status} <br> ${req.paymentType}</td></tr>
                                                    <tr><td height="30">&nbsp;</td></tr> 
                                                        
                                                        
                                                    <tr><td height="30">&nbsp;</td></tr>
                                                    </table>
                                                    
                                                    </td></tr>
                                                
                                               
                                              
                                            </table>
                                            
                                            </td></tr>
                                        </table>
                                        
                                        <!--[if (gte mso 9)|(IE)]></td><td><![endif]-->
                                        
                                        <!-- gap -->
                                        <table class="row" style="width:50px;max-width:50px;" width="50" cellspacing="0" cellpadding="0" border="0" align="left"><tr><td height="30"></td></tr></table>
                                        
                                         <!--[if (gte mso 9)|(IE)]></td><td><![endif]-->
                                        
                                         <!-- column -->    
                                        <table class="row" style="width:230px;max-width:230px;" width="230" cellspacing="0" cellpadding="0" border="0" align="right">
                                        <tr><td align="center">
                                            
                                            <!-- content -->
                                         <table width="230" style="width:230px;max-width:230px;" cellspacing="0" cellpadding="0" border="0" align="center">
                                                
                                                <tr><td height="30">&nbsp;</td></tr>
                                             <tr><td style="font-family:'Josefin Sans', Arial, Helvetica, sans-serif;font-size: 18px;color: #282828;">Shipping Address</td></tr>
                                                    <tr><td height="18">&nbsp;</td></tr>
                                                    <tr><td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 13px;color: #282828;line-height: 22px;"> ${req.customerAddress} <br>${req.postalCode}<br>UK</td></tr>
                                                    <tr><td height="30">&nbsp;</td></tr> 
                                            </table>
                                            
                                            </td></tr>
                                        </table>
                                        
                                  
                                        
                                      
                                        
                                        <!--[if (gte mso 9)|(IE)]></td></tr></table><![endif]-->
                                        </td></tr>
                                          <tr><td height="30">&nbsp;</td></tr> 
                                        </table>
                                        
                                        </td></tr>
                                </table>
                                
                              
                                
                                </td></tr>
                            </table>
                            
                            </td></tr>
               </table>
             
             </td>
               </tr>
        </table>
          <!--module-->
<table  style="width:100%;max-width:100%;" width="100%" cellspacing="0" cellpadding="0" border="0" align="center">
<tr>
               <td bgcolor="#F4F4F4" align="center">
             
                   <!--container-->
                    <table class="row" style="width:600px;max-width:600px;" width="600" cellspacing="0" cellpadding="0" border="0" align="center">
                        <tr><td bgcolor="#282828" align="center">
                            
                            <!--wrapper-->
                            <table class="row" style="width:540px;max-width:540px;" width="540" cellspacing="0" cellpadding="0" border="0" align="center">
                            <tr><td class="container-padding" align="center">
                                
                              
                                
                                <!-- content container -->
                                <table width="540" border="0" cellpadding="0" cellspacing="0" align="center" class="row" style="width:540px;max-width:540px;">
                                    <tr><td align="center">
                                        
                                    <!-- content -->    
                                      <table border="0" width="100%" cellpadding="0" cellspacing="0" align="center" style="width:100%; max-width:100%;">
                                          <tr><td height="40">&nbsp;</td></tr> 
                                     
                              <tr><td align="center" style="font-family:'Josefin Sans', Arial, Helvetica, sans-serif;font-size: 18px;color: #dadada;font-weight: 400;">Get in Touch</td></tr>
                           
                                        <tr><td height="20">&nbsp;</td></tr>
                                           <tr><td>
                                              
                                              <table cellspacing="0" cellpadding="0" border="0" align="center">
                                              <tr>
                                                  <td width="25">
  <a href="https://www.facebook.com/mobilebitz?mibextid=kFxxJD">
    <img width="25" style="display:block; max-width:25px;" src="http://emailmug.com/premium-template/emailpaws/notif/fb.png" alt="Facebook">
  </a>
</td>
<td width="10">&nbsp;</td>
<td width="25">
  <a href="https://www.instagram.com/mobile_bitz_official?igsh=MTE3OWozc2o2aTFsZA==">
    <img width="25" style="display:block; max-width:25px;" src="http://emailmug.com/premium-template/emailpaws/notif/in.png" alt="LinkedIn">
  </a>
</td>

                                                  <td width="10">&nbsp;</td>
                                                 
                                                  </tr>
                                              </table>
                                              
                                              </td></tr>
                                        <tr><td height="20">&nbsp;</td></tr>
                                        <tr><td align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 19px;">This email was sent to : ${req.customerEmail}<br>
                                           This email is intended for the administrator's reference only.<br>
                                            For any questions please send to booking@mobilebitz.co.uk
 </td></tr>
                                          <tr><td>&nbsp;</td></tr>
                                          <tr><td align="center">
                                              
                                              <table cellspacing="0" cellpadding="0" border="0">
                                              <tr>
                                                  <td align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;text-decoration: underline"><a href="https://accessories.mobilebitz.co.uk/Cookies" target="_blank" style="color: #dadada">GDPR consent</a></td>
                                                  <td width="20" align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;">|</td>
                                                  <td align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;text-decoration: underline"><a href="https://accessories.mobilebitz.co.uk/Terms" target="_blank" style="color: #dadada">Terms and Conditions</a></td>
                                                  <td width="20" align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;">|</td>
                                                  <td align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;text-decoration: underline"><a href="https://accessories.mobilebitz.co.uk/Privacy" target="_blank" style="color: #dadada">Privacy Policy</a></td>                                                  <td align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;text-decoration: underline"><a href="http://www.example.com" target="_blank" style="color: #dadada">Privacy Policy</a></td>
                                                  <td width="20" align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;">|</td>
                                                  <td align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;text-decoration: underline"><a href="https://accessories.mobilebitz.co.uk/Faqs" target="_blank" style="color: #dadada">Faqs</a></td>                                                  <td align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;text-decoration: underline"><a href="http://www.example.com" target="_blank" style="color: #dadada">Privacy Policy</a></td>
                                                  </tr>
                                              </table>
                                              
                                              </td></tr>
                                          <tr><td height="40">&nbsp;</td></tr> 
                                        </table>
                                        
                                        </td></tr>
                                </table>
                                
                              
                                
                                </td></tr>
                            </table>
                            
                            </td></tr>
               </table>
             
             </td>
               </tr>
        </table>
    </body>


      `,
    };

    await transporter.sendMail(mailOptions);
    console.log("success admin")
  } catch (error) {
    console.error('Error sending email:', error);
    res.status(500).send('Error sending email');
  }
};



exports.forgotPassVerifyEmail = async function (req, current, res) {
  let email = req.email;
  let id = req._id
  console.log("email====", email)
  console.log("id====", id)
  // let link = `http://localhost:3000/forgotPassword/${id}`;
  // let link = `https://sellyourtechuk.com/forgotPassword/${id}`;
  let link = `${process.env.URL}forgotPassword/${id}`;

  try {
    const mailOptions = {
      from: emailConfig.user,
      to: email,
      subject: `${process.env.BUSINESS_NAME} || Forgot Password Request`,
      html: `
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>OTP</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #000;
            color: #fff;
            margin: 0;
            padding: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
        }

        .email-container {
            background-color: #111;
            color: #fff;
            padding: 20px;
            border-radius: 10px;
            width: 100%;
            max-width: 500px;
            text-align: center;
            box-sizing: border-box;
        }

        .confirmation-text {
            font-size: 18px;
            margin-bottom: 20px;
        }

        .button {
            display: inline-block;
            padding: 10px 20px;
            background-color: #00ff00;
            color: #000;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            cursor: pointer;
        }

        .button:hover {
            background-color: #007700;
        }
    </style>
</head>

<body>
    <div class="email-container">
        <h1>Email Confirmation</h1>
        <p class="confirmation-text">
            Please Don't share this OTP with anyone else!
        </p>
        <p>
            This is your Link, ${link}
        </p>
    </div>
</body>

</html>
      `,
    };
    await transporter.sendMail(mailOptions);
    console.log("email send!")
    return 'Email sent successfully!'
  } catch (error) {
    console.error('Error sending email:', error);
    res.status(500).send('Error sending email');
  }
};


exports.PasswordSuccessUpdate = async function (req, current, res) {
  let email = req.email;

  try {
    const mailOptions = {
      from: emailConfig.user,
      to: email,
      subject: `${process.env.BUSINESS_NAME} || Password Changed Suessfully`,
      html: `
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">  
    <title>Password Changed</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            padding: 20px;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: #fff;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h2 {
            color: #333;
        }
        p {
            color: #666;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Your Password has been Changed</h2>
        <p>Hello ${req.firstname}  ${req.lastname},</p>
        <p>This is to inform you that your password has been successfully changed.</p>
        <p>If you did not initiate this change, please contact us immediately.</p>
        <p>Thank you!</p>
    </div>
</body>

</html>
      `,
    };
    await transporter.sendMail(mailOptions);
    console.log("email send!")
    return 'Email sent successfully!'
  } catch (error) {
    console.error('Error sending email:', error);
    res.status(500).send('Error sending email');
  }
};






exports.removedProduct = async function (removed, user, res) {
  let email = user.email;
  console.log("removed", removed);
  let remove = removed[0].data;
  try {
    const mailOptions = {
      from: emailConfig.user,
      to: email,
      subject: `${process.env.BUSINESS_NAME} || Remove Selling Product`,
      html: `
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Password Changed</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            padding: 20px;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: #fff;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h2 {
            color: #333;
        }
        p {
            color: #666;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Hi ${user.firstname} ${user.lastname}, Your Selected product Have been removed from selling.</h2>
        <p>If you have anyother query please feel free to ask. Our team will contact you soon.</p>
        <h4>Product Details</h4>
        <li><span style="font-weight: bold;">Product ID:</span> ${remove._id}</li>
        <li> <span style="font-weight: bold;">Product Name:</span> ${remove.name}</li>
        <li> <span style="font-weight: bold;">Product Price: </span> ${remove.price}</li>
       <p>Thank you!</p>
    </div>
</body>

</html>
      `,
    };
    await transporter.sendMail(mailOptions);
    console.log("email send!")
    return 'Email sent successfully!'
  } catch (error) {
    console.error('Error sending email:', error);
    res.status(500).send('Error sending email');
  }
};





///  Mail to admin on cash on delivery

exports.MailToAdminForCreatingOrder = async function (order) {
  const currentDate = new Date();
  const month = currentDate.toLocaleString('default', { month: 'long' });
  const date = currentDate.getDate();
  let hours = currentDate.getHours();
  const ampm = hours >= 12 ? 'pm' : 'am';
  hours = hours % 12;
  hours = hours ? hours : 12; // Handle midnight (12:00 am)
  const minutes = currentDate.getMinutes();
  const timeString = `${hours}:${minutes < 10 ? '0' : ''}${minutes} ${ampm}`;
  const formattedDateTime = `${month} ${date} ${timeString}`;
  const subTotal = order.productInfo.reduce((acc, prod) => acc + prod.wholesellerPrice, 0);


  try {
    const mailOptions = {
      from: emailConfig.user,
      to: process.env.ADMIN_MAIL,
      subject: `${process.env.BUSINESS_NAME} || A New Order Placed`,
      html: `
      <body> 
<table  style="width:100%;max-width:100%;" width="100%" cellspacing="0" cellpadding="0" border="0" align="center"> 
<tr>
               <td bgcolor="#F4F4F4" align="center">
             
                   <!--container-->
                    <table class="row" style="width:600px;max-width:600px;" width="600" cellspacing="0" cellpadding="0" border="0" align="center">
                        <tr><td bgcolor="grey" align="center">
                            
                            <!--wrapper-->
                            <table class="row" style="width:540px;max-width:540px;" width="540" cellspacing="0" cellpadding="0" border="0" align="center">
                            <tr><td class="container-padding" align="center">
                                
                              
                                
                                <!-- content container -->
                                <table width="540" border="0" cellpadding="0" cellspacing="0" align="center" class="row" style="width:540px;max-width:540px;">
                                    <tr><td align="center">
                                        
                                    <!-- content -->    
                                      <table border="0" width="100%" cellpadding="0" cellspacing="0" align="center" style="width:100%; max-width:100%;">
                                          <tr><td height="25">&nbsp;</td></tr> 
                                     <tr><td>
                                         <table border="0" width="100%" cellpadding="0" cellspacing="0" align="center">
                                         <tr>
                                             <td width="80" align="left">
                                             <img width="120" style="display:block;;max-width:120px;" alt="img" src="https://mobilebitz.co.uk/logo/logo.png">
                                             </td>
                                             <td>&nbsp;</td>
                                             <td align="right" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #ffffff;"><a href="https://accessories.mobilebitz.co.uk/Faqs" target="_blank" style="color: #ffffff">Faq's</a></td>
                                             </tr>
                                         </table>
                                         </td></tr>
                                          <tr><td height="25">&nbsp;</td></tr> 
                                        </table>
                                        
                                        </td></tr>
                                </table>
                                
                              
                                
                                </td></tr>
                            </table>
                            
                            </td></tr>
               </table>
             
             </td>
               </tr>
        </table>
        <!--module-->
<table  style="width:100%;max-width:100%;" width="100%" cellspacing="0" cellpadding="0" border="0" align="center">
<tr>
               <td bgcolor="#F4F4F4" align="center">
             
                   <!--container-->
                    <table class="row" style="width:600px;max-width:600px;" width="600" cellspacing="0" cellpadding="0" border="0" align="center">
                        <tr><td bgcolor="#f6f6f4" align="center">
                            
                            <!--wrapper-->
                            <table class="row" style="width:540px;max-width:540px;" width="540" cellspacing="0" cellpadding="0" border="0" align="center">
                            <tr><td class="container-padding" align="center">
                                
                              
                                
                                <!-- content container -->
                                <table width="540" border="0" cellpadding="0" cellspacing="0" align="center" class="row" style="width:540px;max-width:540px;">
                                    <tr><td align="center">
                                        
                                    <!-- content -->    
                                      <table border="0" width="100%" cellpadding="0" cellspacing="0" align="center" style="width:100%; max-width:100%;">
                                          <tr><td height="30">&nbsp;</td></tr> 
                                     <tr><td align="center"><img width="100" style="display:block;;max-width:100px;" alt="img" src="http://emailmug.com/premium-template/emailpaws/notif/cr.png"></td></tr>
                                     <tr><td height="20">&nbsp;</td></tr>
                             <tr><td align="center" style="font-family:'Josefin Sans', Arial, Helvetica, sans-serif;font-size: 30px;color: #282828;">New Order Placed</td></tr>
                                          <tr><td height="18">&nbsp;</td></tr>
                             <tr><td align="center" style="font-family:'Josefin Sans', Arial, Helvetica, sans-serif;font-size: 24px;color: #282828;line-height: 25px;">A Customer Placed a order on MobileBitz.
                                 <br><strong><span style="font-size: 15px">${formattedDateTime}</span></strong> </td></tr>
                            <tr><td height="18">&nbsp;</td></tr>
                             <tr><td align="center" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 15px;color: #282828;">Hurry up fulfill your customer order and don't let them wait.</td></tr>
                                          <tr><td height="25">&nbsp;</td></tr>
                             <tr><td align="center">
                                 
                                      <!--button-->
                                              <table border="0" bgcolor="#9c8563" cellpadding="0" cellspacing="0"><tr>
                           
                            <td  align="center" height="40" width="170" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 13px;color: #ffffff;font-weight: 600;letter-spacing: 0.5px;">
                            
                            
                                <a href="https://backoffice.mobilebitz.co.uk/AllOrders" target="_blank" style="color: #ffffff">VIEW ORDER</a>
                            </td>
                           
                            </tr></table>
                                 
                                 </td></tr>
                                         
                                          <tr><td height="30">&nbsp;</td></tr> 
                                        </table>
                                        
                                        </td></tr>
                                </table>
                                
                              
                                
                                </td></tr>
                            </table>
                            
                            </td></tr>
               </table>
             
             </td>
               </tr>
        </table>
                <!--module-->
<table  style="width:100%;max-width:100%;" width="100%" cellspacing="0" cellpadding="0" border="0" align="center">
<tr>
               <td bgcolor="#F4F4F4" align="center">
             
                   <!--container-->
                    <table class="row" style="width:600px;max-width:600px;" width="600" cellspacing="0" cellpadding="0" border="0" align="center">
                        <tr><td bgcolor="#FFFFFF" align="center">
                            
                            <!--wrapper-->
                            <table class="row" style="width:540px;max-width:540px;" width="540" cellspacing="0" cellpadding="0" border="0" align="center">
                            <tr><td class="container-padding" align="center">
                                
                              
                                
                                <!-- content container -->
                                <table width="540" border="0" cellpadding="0" cellspacing="0" align="center" class="row" style="width:540px;max-width:540px;">
                                    <tr><td align="center">
                                        
                                    <!-- content -->    
                                      <table border="0" width="100%" cellpadding="0" cellspacing="0" align="center" style="width:100%; max-width:100%;">
                                          <tr><td height="30">&nbsp;</td></tr> 
                                     
                             <tr><td>
                                 <table border="0" width="100%" cellpadding="0" cellspacing="0" align="center">
                                 <tr>
                                     <td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 13px;color: #282828;">Order Number #${order.orderNumber}</td>
                                     <td width="30">&nbsp;</td>
                                     <td align="right" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 13px;color: #282828;">Items Price</td>
                                     </tr>
                                 </table>
                                 </td></tr>
                             <tr><td style="line-height: 8px;height: 8px;font-size: 0px;">&nbsp;</td></tr>
                             <tr><td bgcolor="#e7e6e2" style="line-height: 8px;height: 8px;font-size: 0px;">&nbsp;</td></tr>
                             <tr><td height="20">&nbsp;</td></tr>
                             <tr><td>
                                  ${order.productInfo.map((product, index) => `
    <table key=${index} border="0" width="100%" cellpadding="0" cellspacing="0" align="center"> 
      <tr>
        <td style="font-family:'Josefin Sans', Arial, Helvetica, sans-serif;font-size: 18px;color: #282828;line-height: 21px;">${product.subsubcatagory}</td>
        <td width="20">&nbsp;</td>
        <td width="250">
          <table border="0" width="100%" cellpadding="0" cellspacing="0"> 
            <tr><td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;line-height: 21px;">Quantity: ${product.quantity}</td></tr>
          </table>
        </td>
        <td>&nbsp;</td>
        <td align="right" width="60">
          <table border="0" width="60" cellpadding="0" cellspacing="0">
            <tr><td align="right" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 18px;color: #282828;"> ₤ ${product.productPrice}</td></tr>
          </table>
        </td>
      </tr>
    </table>
  `).join('')}
                                 </td></tr>
                                          <tr><td height="20" style="border-bottom: 1px solid #e0e0e0">&nbsp;</td></tr> 
                                          <tr><td height="20">&nbsp;</td></tr>
                                             <tr><td>
                               
                                 </td></tr>
                                          <tr><td height="20">&nbsp;</td></tr> 
                                           <tr><td bgcolor="#e7e6e2" style="line-height: 8px;height: 8px;font-size: 0px;">&nbsp;</td></tr>
                                          <tr><td height="30">&nbsp;</td></tr>
                                          <tr><td align="right">
                                              
                                              <table border="0" width="280" cellpadding="0" cellspacing="0">
                                                  <tr>
                                                      <td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;line-height: 24px;">Subtotal</td>
                                                      <td>&nbsp;</td>
                                                      <td align="right" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;"> ₤ ${subTotal / 100}</td>
                                                  </tr>
                                                  <tr>
                                                      <td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;line-height: 24px;">Delivery Charges</td>
                                                      <td>&nbsp;</td>
                                                     <td align="right" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;"> ₤ ${order.deliverycharges}</td>
                                                  </tr>
                                                  
                                                  <tr>
                                                      <td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;line-height: 24px;">Discount</td>
                                                      <td>&nbsp;</td>
                                                     <td align="right" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;text-decoration: ">  ₤ ${order.discount}</td>
                                                  </tr>
                                                  <tr>
                                                      <td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 18px;color: #282828;font-weight: 600;line-height: 24px;">Total</td>
                                                      <td>&nbsp;</td>
                                                      <td align="right" style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 18px;color: #282828;"><strong>  ₤ ${subTotal / 100 + order.deliverycharges - order.discount}</strong></td>
                                                  </tr>
                                                  <tr>
                                                      <td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 14px;color: #282828;line-height: 24px;">&nbsp;</td>
                                                      <td>&nbsp;</td> 
                                                  </tr>
                                              </table>
                                              </td></tr>
                                             <tr><td height="30">&nbsp;</td></tr> 
                                           <tr><td bgcolor="#e7e6e2" style="line-height: 8px;height: 8px;font-size: 0px;">&nbsp;</td></tr>
                                          <tr><td style="line-height: 15px;height: 15px;font-size: 0px;">&nbsp;</td></tr>
                                        </table>
                                        
                                        </td></tr>
                                </table>
                                
                              
                                
                                </td></tr>
                            </table>
                            
                            </td></tr>
               </table>
             
             </td>
               </tr>
        </table>
            
        <!--module-->
<table  style="width:100%;max-width:100%;" width="100%" cellspacing="0" cellpadding="0" border="0" align="center">
<tr>
               <td bgcolor="#F4F4F4" align="center">
             
                   <!--container-->
                    <table class="row" style="width:600px;max-width:600px;" width="600" cellspacing="0" cellpadding="0" border="0" align="center">
                        <tr><td bgcolor="#FFFFFF" align="center">
                            
                            <!--wrapper-->
                            <table class="row" style="width:540px;max-width:540px;" width="540" cellspacing="0" cellpadding="0" border="0" align="center">
                            <tr><td class="container-padding" align="center">
                                
                              
                                
                                <!-- content container -->
                                <table width="540" border="0" cellpadding="0" cellspacing="0" align="center" class="row" style="width:540px;max-width:540px;">
                                    <tr><td align="center">
                                        
                                    <!-- content -->    
                                      <table border="0" width="100%" cellpadding="0" cellspacing="0" align="center" style="width:100%; max-width:100%;">
                                          <tr><td style="line-height: 15px;height: 15px;font-size: 0px;">&nbsp;</td></tr> 

                                          <tr><td align="center">
                                        
                                        <!--[if (gte mso 9)|(IE)]><table border="0" cellpadding="0" cellspacing="0"><tr><td><![endif]-->
                                        
                                    <!-- column -->    
                                        <table class="row" style="width:260px;max-width:260px;" width="260" cellspacing="0" cellpadding="0" border="0" align="left">
                                        <tr><td align="center">
                                            
                                            <!-- content -->
                                            <table width="260" style="width:260px;max-width:260px;" cellspacing="0" cellpadding="0" border="0" align="center">
                                                
                                                <tr><td align="center" bgcolor="#F5F5F3">
                                                    
                                                    <table border="0" width="200" cellpadding="0" cellspacing="0" align="center">
                                                    <tr><td height="30">&nbsp;</td></tr>
                                                        
                                                        
                                                    <tr><td style="font-family:'Josefin Sans', Arial, Helvetica, sans-serif;font-size: 18px;color: #282828;">Billing Address</td></tr>
                                                    <tr><td height="18">&nbsp;</td></tr>
                                                    <tr><td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 13px;color: #282828;line-height: 22px;"><br> ${order.paymentStatus} <br> ${order.paymentType}</td></tr>
                                                    <tr><td height="30">&nbsp;</td></tr> 
                                                        
                                                        
                                                    <tr><td height="30">&nbsp;</td></tr>
                                                    </table>
                                                    
                                                    </td></tr>
                                                
                                               
                                              
                                            </table>
                                            
                                            </td></tr>
                                        </table>
                                        
                                        <!--[if (gte mso 9)|(IE)]></td><td><![endif]-->
                                        
                                        <!-- gap -->
                                        <table class="row" style="width:50px;max-width:50px;" width="50" cellspacing="0" cellpadding="0" border="0" align="left"><tr><td height="30"></td></tr></table>
                                        
                                         <!--[if (gte mso 9)|(IE)]></td><td><![endif]-->
                                        
                                         <!-- column -->    
                                        <table class="row" style="width:230px;max-width:230px;" width="230" cellspacing="0" cellpadding="0" border="0" align="right">
                                        <tr><td align="center">
                                            
                                            <!-- content -->
                                         <table width="230" style="width:230px;max-width:230px;" cellspacing="0" cellpadding="0" border="0" align="center">
                                                
                                                <tr><td height="30">&nbsp;</td></tr>
                                             <tr><td style="font-family:'Josefin Sans', Arial, Helvetica, sans-serif;font-size: 18px;color: #282828;">Shipping Address</td></tr>
                                                    <tr><td height="18">&nbsp;</td></tr>
                                                    <tr><td style="font-family:'Open Sans', Arial, Helvetica, sans-serif;font-size: 13px;color: #282828;line-height: 22px;"> ${order.customerAddress} <br>${order.postalCode}<br>UK</td></tr>
                                                    <tr><td height="30">&nbsp;</td></tr> 
                                            </table>
                                            
                                            </td></tr>
                                        </table>
                                        
                                  
                                        
                                      
                                        
                                        <!--[if (gte mso 9)|(IE)]></td></tr></table><![endif]-->
                                        </td></tr>
                                          <tr><td height="30">&nbsp;</td></tr> 
                                        </table>
                                        
                                        </td></tr>
                                </table>
                                
                              
                                
                                </td></tr>
                            </table>
                            
                            </td></tr>
               </table>
             
             </td>
               </tr>
        </table>
          <!--module-->
<table  style="width:100%;max-width:100%;" width="100%" cellspacing="0" cellpadding="0" border="0" align="center">
<tr>
               <td bgcolor="#F4F4F4" align="center">
             
                   <!--container-->
                    <table class="row" style="width:600px;max-width:600px;" width="600" cellspacing="0" cellpadding="0" border="0" align="center">
                        <tr><td bgcolor="#282828" align="center">
                            
                            <!--wrapper-->
                            <table class="row" style="width:540px;max-width:540px;" width="540" cellspacing="0" cellpadding="0" border="0" align="center">
                            <tr><td class="container-padding" align="center">
                                
                              
                                
                                <!-- content container -->
                                <table width="540" border="0" cellpadding="0" cellspacing="0" align="center" class="row" style="width:540px;max-width:540px;">
                                    <tr><td align="center">
                                        
                                    <!-- content -->    
                                      <table border="0" width="100%" cellpadding="0" cellspacing="0" align="center" style="width:100%; max-width:100%;">
                                          <tr><td height="40">&nbsp;</td></tr> 
                                     
                              <tr><td align="center" style="font-family:'Josefin Sans', Arial, Helvetica, sans-serif;font-size: 18px;color: #dadada;font-weight: 400;">Get in Touch</td></tr>
                           
                                        <tr><td height="20">&nbsp;</td></tr>
                                           <tr><td>
                                              
                                              <table cellspacing="0" cellpadding="0" border="0" align="center">
                                              <tr>
                                                  <td width="25">
  <a href="https://www.facebook.com/mobilebitz?mibextid=kFxxJD">
    <img width="25" style="display:block; max-width:25px;" src="http://emailmug.com/premium-template/emailpaws/notif/fb.png" alt="Facebook">
  </a>
</td>
<td width="10">&nbsp;</td>
<td width="25">
  <a href="https://www.instagram.com/mobile_bitz_official?igsh=MTE3OWozc2o2aTFsZA==">
    <img width="25" style="display:block; max-width:25px;" src="http://emailmug.com/premium-template/emailpaws/notif/in.png" alt="LinkedIn">
  </a>
</td>

                                                  <td width="10">&nbsp;</td>
                                                 
                                                  </tr>
                                              </table>
                                              
                                              </td></tr>
                                        <tr><td height="20">&nbsp;</td></tr>
                                          <tr><td>&nbsp;</td></tr>
                                          <tr><td align="center">
                                              
                                              <table cellspacing="0" cellpadding="0" border="0">
                                              <tr>
                                                  <td align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;text-decoration: underline"><a href="${process.env.URL}/Cookies" target="_blank" style="color: #dadada">GDPR consent</a></td>
                                                  <td width="20" align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;">|</td>
                                                  <td align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;text-decoration: underline"><a href="${process.env.URL}/Terms" target="_blank" style="color: #dadada">Terms and Conditions</a></td>
                                                  <td width="20" align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;">|</td>
                                                  <td align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;text-decoration: underline"><a href="${process.env.URL}/Privacy" target="_blank" style="color: #dadada">Privacy Policy</a></td>                                                  
                                                  <td width="20" align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;">|</td>
                                                  <td align="center" style="font-family:'Roboto', Arial, Helvetica, sans-serif;font-size: 13px;color: #dadada;line-height: 20px;text-decoration: underline"><a href="${process.env.URL}/Faqs" target="_blank" style="color: #dadada">Faqs</a></td>                                                  
                                                  </tr>
                                              </table>
                                              
                                              </td></tr>
                                          <tr><td height="40">&nbsp;</td></tr> 
                                        </table>
                                        
                                        </td></tr>
                                </table>
                                
                              
                                
                                </td></tr>
                            </table>
                            
                            </td></tr>
               </table>
             
             </td>
               </tr>
        </table>
    </body>

      `
    };
    await transporter.sendMail(mailOptions);
  } catch (error) {
    console.log('Error sending mail:', error);
  }
}
